# number of timesteps (months) over which to iterate model
t_max = 12

# initialise an empty vector to store the population sizes
# over time; the first value will correspond to month 0,
# i.e., t=0
Fs = numeric(t_max+1)
# set the initial population size to zero
Fs[1] = 0
# introduce a pair of rabbits in month t=1
Fs[2] = 1

# execute a loop from month t=2 to t=t_max, in each step
# calculating the value of the population size at month t
# from the Fibonacci formula
for ( t in 2:t_max )
  Fs[t+1] = Fs[t] + Fs[t-1]

# plot the results
plot(0:t_max,Fs,pch=19,type='o',xlab='t',ylab='F')
